package com.zzsn.event.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.entity.LabelEntity;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.vo.LabelTypeVO;
import com.zzsn.event.vo.SysLabelVo;

import java.util.List;

/**
 * @author lkg
 * @date 2023/3/2
 */
public interface LabelEntityService extends IService<LabelEntity> {

    String ROOT_ID = "0";

    Object pageList(SysLabelVo sysLabelVo, Integer pageNo, Integer pageSize);

    /**
     * 根据分类获取标签列表
     *
     * @param labelTypeId 标签分类id
     * @author lkg
     * @date 2024/1/22
     */
    List<LabelEntity> listByType(String labelTypeId);

    /**
     * 地域信息列表-树型结构
     *
     * @param type 类别(1-国际;2-国内)
     * @author lkg
     * @date 2024/4/10
     */
    List<LabelTypeVO> regionTree(Integer type);

    List<LabelTypeVO> firstLevelRegions();

    /**
     * 国标行业列表-树型结构
     *
     * @author lkg
     * @date 2024/12/27
     */
    List<LabelTypeVO> industryTree();
}
