package com.zzsn.event.vo;

import lombok.Data;

import java.util.List;

@Data
public class EventDataCondition {

    //专题id/专题分类id
    private String subjectId;

    //搜索时，全部情况下，，搜索传值
    private String search;

    //专题标题
    private String title;

    //专题摘要
    private String summary;

    //内容
    private String content;

    //发布时间
    private String publishDate;

    //来源
    private String origin;

    //区域
    private String area;

    //开始时间
    private String startTime;

    //结束时间
    private String endTime;

    //专题库类型(对应字典编码为【Thematic_Library】的数据字典值)
    private Integer classificationType;

    //审核操作(0：未审核  1：审核通过  2：审核未通过  3：暂定  默认值为0)
    private Integer checkStatus;

    //删除标记(1:删除；0:保留)
    private Integer deleteFlag = 0;

    //关联标签名称
    private String labelName;

    //是否专题下所有信息源(1-是;0-否)
    private String isAll;

    //专题分类(1-专题;2-事件)
    private Integer category;
    //是否视频 "video"
    private String video;
    //subjectId是否专题id(1-是;0-否)
    private String isSubject = "1";
    //爬虫类型
    private String crawler;
    //企业标签id集合
    private List<String> labelTypeIds;
    //关联标签id集合
    private List<String> labelIds;
    //信息源id
    private String sourceId;
    //搜索词信息集合
    private List<SearchWordVO> searchWordList;

    //关键词信息；推荐信息源时使用
    private List<String> wordsList;


    //是否免审核(1-是;0-否)
    private Integer isFreeCheck;

    //得分范围
    //最小得分
    private Integer minScore;
    //最大得分
    private Integer maxScore;

    //es查询字段数组
    private String[] fetchFields;

    //排序参数
    //排序字段
    private String column = "common";
    //排序方式 asc/desc
    private String order = "desc";

    //分页参数
    //当前页
    private Integer pageNo = 1;
    //每页返回条数
    private Integer pageSize = 10;

    //资讯id集合，导出/专题分析时 使用
    private List<String> ids;

    /*------资讯导出类参数---start-------------------*/
    //导出方式(1-摘要;2-正文)
    private Integer exportType;
    /*------资讯导出类参数---end-------------------*/


    /*------专题分析类参数---start-------------------*/
    //聚合分组类型-按日期集合分析时使用
    private String groupType;
    //选择的前num条数据-专题分析时使用
    private Integer num;
    //信息源id集合-统计分析资讯量最多的信息源时使用
    private List<String> sourceIdList;
    //聚合包含的字段值的集合
    private String[] includeValues;
    //聚合排除的字段值的集合
    private String[] excludeValues;
    /*------专题分析类参数---end-------------------*/
}
