package com.zzsn.event.service.impl;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.InfoSource;
import com.zzsn.event.es.EsService;
import com.zzsn.event.mapper.InfoSourceMapper;
import com.zzsn.event.service.IInfoSourceService;
import com.zzsn.event.vo.InfoSourceCondition;
import com.zzsn.event.vo.InfoSourceVo;
import com.zzsn.event.vo.NumVO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Description: 信息源表
 * @Author: jeecg-boot
 * @Date:   2022-01-18
 * @Version: V1.0
 */
@Service
public class InfoSourceServiceImpl extends ServiceImpl<InfoSourceMapper, InfoSource> implements IInfoSourceService {

    @Autowired
    private EsService esService;

    @Override
    public IPage<InfoSource> pageList(InfoSourceCondition infoSourceCondition, Integer pageNo, Integer pageSize) {
        Page<InfoSource> page = new Page<>(pageNo, pageSize);
        return baseMapper.pageList(infoSourceCondition, page);
    }

    @Override
    public IPage<InfoSourceVo> bindInfoSourceList(InfoSourceCondition infoSourceCondition, List<String> subjectIds, Integer pageNo, Integer pageSize) {
        int offset = (pageNo - 1) * pageSize;
        if (pageNo == 0) {
            offset = 0;
        }
        List<InfoSourceVo> pageList = new ArrayList<>();
        List<String> bindList = baseMapper.bindSourceIdList(infoSourceCondition,subjectIds,offset,pageSize);
        if (CollectionUtils.isNotEmpty(bindList)) {
            List<InfoSourceVo> infoSourceVos = baseMapper.bindGroupSourceIdList(subjectIds, bindList);
            Map<String, InfoSourceVo> collect1 = infoSourceVos.stream().collect(Collectors.toMap(InfoSourceVo::getId, Function.identity(), (exist, replace) -> exist));
            pageList = baseMapper.queryInfoSource(bindList,subjectIds);
            for (InfoSourceVo infoSourceVo1 : pageList) {
                //数据配置
                if (ObjectUtil.isEmpty(infoSourceVo1.getIsFreeCheck())){
                    InfoSourceVo infoSourceVo2 = collect1.get(infoSourceVo1.getId());
                    if (infoSourceVo2 != null) {
                        infoSourceVo1.setIsFreeCheck(infoSourceVo2.getIsFreeCheck());
                    }
                }
                if (ObjectUtil.isEmpty(infoSourceVo1.getIsExemptKeyword())){
                    InfoSourceVo infoSourceVo2 = collect1.get(infoSourceVo1.getId());
                    if (infoSourceVo2 != null) {
                        infoSourceVo1.setIsExemptKeyword(infoSourceVo2.getIsExemptKeyword());
                    }
                }
                //性质
                if (StringUtils.isNotEmpty(infoSourceVo1.getNatureIds())) {
                    String natureIds = infoSourceVo1.getNatureIds();
                    List<String> natureIdList = Arrays.asList(natureIds.split(","));
                    infoSourceVo1.setInfoSourceNatureIds(natureIdList);
                }
                //采集量
                NumVO totalCollectCount = esService.count(infoSourceVo1.getId(), null, null, 1);
                //总采集量
                infoSourceVo1.setTotalCount(totalCollectCount.getCount());
                Date endTime = new Date();
                DateTime startTime = DateUtil.offsetDay(endTime, -30);
                //月采集量
                NumVO monthCollectCount = esService.count(infoSourceVo1.getId(), DateUtil.formatDate(startTime), DateUtil.formatDate(endTime), 2);
                infoSourceVo1.setMonthCount(monthCollectCount.getCount());

                List<NumVO> children = monthCollectCount.getChildren();
                Map<String, List<NumVO>> collect = children.stream().collect(Collectors.groupingBy(NumVO::getKey));
                //周采集量
                long weekCount = 0L;
                List<DateTime> rangeToList = DateUtil.rangeToList(DateUtil.offsetDay(endTime, -7), endTime, DateField.DAY_OF_YEAR);
                for (DateTime dateTime : rangeToList) {
                    List<NumVO> countVOS = collect.get(DateUtil.formatDate(dateTime));
                    if (CollectionUtils.isNotEmpty(countVOS)) {
                        weekCount += countVOS.get(0).getCount();
                    }
                }
                infoSourceVo1.setWeekCount(weekCount);
                //昨日采集量
                DateTime yesterday = DateUtil.yesterday();
                List<NumVO> countVOS = collect.get(DateUtil.formatDate(yesterday));
                if (CollectionUtils.isNotEmpty(countVOS)) {
                    infoSourceVo1.setYesterdayCount(countVOS.get(0).getCount());
                } else {
                    infoSourceVo1.setYesterdayCount(0L);
                }
            }
        }
        Long count = baseMapper.bindSourceIdCount(infoSourceCondition, subjectIds);
        IPage<InfoSourceVo> pageData = new Page<>(pageNo, pageSize, count);
        pageData.setRecords(pageList);
        return pageData;
    }

    @Override
    public IPage<InfoSourceVo> unBindSourcePageList(InfoSourceCondition infoSourceCondition, Integer pageNo, Integer pageSize) {
        Page<InfoSourceVo> page = new Page<>(pageNo, pageSize);
        return baseMapper.unBindSourcePageList(infoSourceCondition, page);
    }

    @Override
    public Integer bindSourceCount(List<String> subjectIds) {
        Long count = baseMapper.bindSourceIdCount(null, subjectIds);
        return count.intValue();
    }

    @Override
    public IPage<Map<String, Object>> subjectBindDirectSourcePageList(String subjectId, Integer pageNo, Integer pageSize) {
        Page<Map<String, Object>> page = new Page<>(pageNo, pageSize);
        return baseMapper.subjectBindDirectInfoSourceList(subjectId, page);
    }

    @Override
    public IPage<String> directSourcePageList(String searchWord, Integer pageNo, Integer pageSize) {
        Page<String> page = new Page<>(pageNo, pageSize);
        return baseMapper.infoSourcePageList(searchWord, page);
    }

    @Override
    public IPage<InfoSource> directSourceColumnPageList(String webSiteName, Integer pageNo, Integer pageSize) {
        Page<InfoSource> page = new Page<>(pageNo, pageSize);
        return baseMapper.directSourceColumnList(webSiteName, page);
    }

    @Override
    public List<InfoSource> directSourceColumnList(String webSiteName) {
        return baseMapper.directSourceColumnList(webSiteName);
    }

    @Override
    public Set<String> directSourceColumnSet(List<String> webSiteNames) {
        return baseMapper.directSourceColumnSet(webSiteNames);
    }

    @Override
    public IPage<InfoSourceVo> bindInfoSourcePageList(InfoSourceCondition infoSourceCondition, List<String> subjectIds, Integer pageNo, Integer pageSize) {
        Page<InfoSourceVo> page = new Page<>(pageNo, pageSize);
        IPage<InfoSourceVo> pageList = baseMapper.bindSourceIdPageList(page, infoSourceCondition, subjectIds);
        //补充附加字段
        if(pageList!=null && CollectionUtils.isNotEmpty(pageList.getRecords())){
            List<String> sourceIds = pageList.getRecords().stream().map(InfoSourceVo::getId).collect(Collectors.toList());
            //以下查询逻辑有问题，需要重构
            List<InfoSourceVo> infoSourceVos = baseMapper.bindGroupSourceIdList(subjectIds,sourceIds);
            Map<String, InfoSourceVo> collect1 = infoSourceVos.stream().collect(Collectors.toMap(InfoSourceVo::getId, Function.identity(), (exist, replace) -> exist));
            for (InfoSourceVo infoSourceVo1 : pageList.getRecords()){
                //数据配置0 = {InfoSourceVo@15933} "InfoSourceVo(id=1534709283536326658, infoSourceCode=null, webSiteName=国资小新, siteName=国资小新, siteUri=https://mp.weixin.qq.com/mp/profile_ext?action=home&__biz=MjM5MDIxNjczNA==&scene=124#wechat_redirect, authMode=null, remarks=null, biz=null, ynBigV=0, authority=null, infoSourceTypeId=null, infoSourceTypeName=null, infoSourceNatureIds=null, natureIds=null, infoSourceNatureNames=null, infoSourceGroupNames=null, siteLevel=null, country=null, area=null, language=null, checkedList=null, hisUriExp=null, hisDateStartTime=null, hisDateEndTime=null, ynHisDataAll=null, status=1, listUrl=null, listExpressionType=null, informationUrl=null, informationTitle=null, informationPublishDate=null, informationSource=null, infoBlockPosition=null, linkLocation=null, extractInfo=null, crawlDepth=null, pageUrl=null, matchPage=null, pageStart=0, pageEnd=0, ynPageAll=null, detailUrl=0, detailExpressionType=null, detailExpressionTitle=null, titleExtractionMethodType=null, titleExtractionMethod=null, detailExpressi"…视图
                if (ObjectUtil.isEmpty(infoSourceVo1.getIsFreeCheck())){
                    InfoSourceVo infoSourceVo2 = collect1.get(infoSourceVo1.getId());
                    if (infoSourceVo2 != null) {
                        infoSourceVo1.setIsFreeCheck(infoSourceVo2.getIsFreeCheck());
                    }
                }
                if (ObjectUtil.isEmpty(infoSourceVo1.getIsExemptKeyword())){
                    InfoSourceVo infoSourceVo2 = collect1.get(infoSourceVo1.getId());
                    if (infoSourceVo2 != null) {
                        infoSourceVo1.setIsExemptKeyword(infoSourceVo2.getIsExemptKeyword());
                    }
                }
                //性质
                if (StringUtils.isNotEmpty(infoSourceVo1.getNatureIds())) {
                    String natureIds = infoSourceVo1.getNatureIds();
                    List<String> natureIdList = Arrays.asList(natureIds.split(","));
                    infoSourceVo1.setInfoSourceNatureIds(natureIdList);
                }
                /*//采集量
                NumVO totalCollectCount = esService.count(infoSourceVo1.getId(), null, null, 1);
                //总采集量
                infoSourceVo1.setTotalCount(totalCollectCount.getCount());
                Date endTime = new Date();
                DateTime startTime = DateUtil.offsetDay(endTime, -30);
                //月采集量
                NumVO monthCollectCount = esService.count(infoSourceVo1.getId(), DateUtil.formatDate(startTime), DateUtil.formatDate(endTime), 2);
                infoSourceVo1.setMonthCount(monthCollectCount.getCount());

                List<NumVO> children = monthCollectCount.getChildren();
                Map<String, List<NumVO>> collect = children.stream().collect(Collectors.groupingBy(NumVO::getKey));
                //周采集量
                long weekCount = 0L;
                List<DateTime> rangeToList = DateUtil.rangeToList(DateUtil.offsetDay(endTime, -7), endTime, DateField.DAY_OF_YEAR);
                for (DateTime dateTime : rangeToList) {
                    List<NumVO> countVOS = collect.get(DateUtil.formatDate(dateTime));
                    if (CollectionUtils.isNotEmpty(countVOS)) {
                        weekCount += countVOS.get(0).getCount();
                    }
                }
                infoSourceVo1.setWeekCount(weekCount);
                //昨日采集量
                DateTime yesterday = DateUtil.yesterday();
                List<NumVO> countVOS = collect.get(DateUtil.formatDate(yesterday));
                if (CollectionUtils.isNotEmpty(countVOS)) {
                    infoSourceVo1.setYesterdayCount(countVOS.get(0).getCount());
                } else {
                    infoSourceVo1.setYesterdayCount(0L);
                }*/
            }
        }
        return pageList;
    }
}
