package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;

import java.io.Serializable;

/**
 * @author lkg
 * @description: 用户数据权限
 * @date 2022/6/20 11:59
 */
@Data
@TableName("sys_user_data_permission")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="sys_user_data_permission对象", description="用户数据权限表")
public class SysUserDataPermission implements Serializable {
    private static final long serialVersionUID = 1L;

    /**主键*/
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
    /**用户id*/
    @Excel(name = "用户id", width = 15)
    @ApiModelProperty(value = "用户id")
    private String userId;
    /**权限id*/
    @Excel(name = "权限id", width = 15)
    @ApiModelProperty(value = "权限id")
    private String permissionId;
    /**权限类别*/
    @Excel(name = "权限类别", width = 15)
    @ApiModelProperty(value = "权限类别")
    private String category;
}
