package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.entity.SubjectType;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.vo.SubjectTreeVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description: 专题类别
 * @Author: jeecg-boot
 * @Date: 2021-12-01
 * @Version: V1.0
 */
@Mapper
public interface SubjectTypeMapper extends BaseMapper<SubjectType> {

    /**
     * 可用的专题分类列表
     *
     * @param userId     用户id
     * @param customerId 客户id
     * @author lkg
     * @date 2024/4/29
     */
    List<Node> enableList(@Param("userId") String userId, @Param("customerId") String customerId);

    /**
     * 可用的专题和专题分类列表
     *
     * @param userId     用户id
     * @param customerId 客户id
     * @author lkg
     * @date 2024/4/29
     */
    List<SubjectTreeVO> subjectAndTypeTree(@Param("userId") String userId, @Param("customerId") String customerId);

    /**
     * 可用的专题和客户列表
     *
     * @param userId     用户id
     * @param customerId 客户id
     * @author lkg
     * @date 2024/4/30
     */
    List<SubjectTreeVO> subjectAndCustomerTree(@Param("userId") String userId, @Param("customerId") String customerId);

    /**
     * 可用客户信息列表
     *
     * @param customerId 客户id
     * @author lkg
     * @date 2024/4/30
     */
    List<SubjectTreeVO> enableCustomerList(@Param("customerId") String customerId);

    /**
     * 更新分类是否有子节点状态
     *
     * @param id       分类id
     * @param hasChild 是否有子节点
     * @author lkg
     * @date 2024/4/29
     */
    void updateTreeNodeStatus(@Param("id") String id, @Param("hasChild") Integer hasChild);
}
