package com.zzsn.event.enums;

public enum ModelTypeEnum {
    REMOVE_MODEL("1", "去重模型"),

    CHOSE_MODEL("2", "筛选模型"),

    LABEL_MODEL("3", "标签模型"),
    MARK_MODEL("4", "打分模型"),
    CLASSIFY_MODEL("5", "分类模型"),
    EXTRACT_MODEL("6", "抽取模型"),
    OTHER_MODEL("31", "其他模型"),

    KEYWORDS_FILTER("keywords","关键词过滤-非模型"),
    UNKNOWN("999", "未知模型");

    private final String value;
    private final String des;

    ModelTypeEnum(String value, String des) {
        this.value = value;
        this.des = des;
    }

    public static ModelTypeEnum getByValue(String value){

        for (ModelTypeEnum type : ModelTypeEnum.values()) {
            if (type.value.equals(value)) {
                return type;
            }
        }
        return ModelTypeEnum.UNKNOWN;
    }
    public String getValue() {
        return value;
    }

    public String getDes() {
        return des;
    }
}
