package com.zzsn.event.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.vo.InfoSourceCondition;
import com.zzsn.event.vo.InfoSourceVo;
import com.zzsn.event.entity.InfoSource;
import com.zzsn.event.vo.SubjectBindDirectSourceVO;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @Description: 信息源表
 * @Author: jeecg-boot
 * @Date: 2022-01-18
 * @Version: V1.0
 */
public interface IInfoSourceService extends IService<InfoSource> {


    IPage<InfoSource> pageList(InfoSourceCondition infoSourceCondition, Integer pageNo, Integer pageSize);

    /**
     * 专题绑定信息源列表
     *
     * @param infoSourceCondition 筛选条件
     * @param subjectIds          专题id集合
     * @param pageNo              当前页
     * @param pageSize            返回条数
     * @author lkg
     * @date 2024/5/7
     */
    IPage<InfoSourceVo> bindInfoSourceList(InfoSourceCondition infoSourceCondition, List<String> subjectIds, Integer pageNo, Integer pageSize);

    /**
     * 专题直接屏蔽的信息源列表(不包括专题屏蔽的信息源组下的信息源)
     *
     * @param infoSourceCondition 筛选条件
     * @param pageNo              当前页
     * @param pageSize            返回条数
     * @author lkg
     * @date 2024/4/30
     */
    IPage<InfoSourceVo> unBindSourcePageList(InfoSourceCondition infoSourceCondition, Integer pageNo, Integer pageSize);


    /**
     * 专题/事件绑定的信息源总数量
     *
     * @param subjectIds 专题/事件id
     * @author lkg
     * @date 2024/4/24
     */
    Integer bindSourceCount(List<String> subjectIds);


    /**
     * 专题绑定的定向信息源分页列表(专题绑定定向信息源时使用-研究中心)
     *
     * @param subjectId 专题id
     * @param pageNo     当前页
     * @param pageSize   返回条数
     * @author lkg
     * @date 2025/1/4
     */
    IPage<SubjectBindDirectSourceVO> subjectBindDirectSourcePageList(String subjectId, Integer pageNo, Integer pageSize);

    /**
     * 信息源分页列表(专题绑定定向信息源时使用-研究中心)
     *
     * @param searchWord 搜索词
     * @param pageNo     当前页
     * @param pageSize   返回条数
     * @author lkg
     * @date 2025/1/4
     */
    IPage<SubjectBindDirectSourceVO> directSourcePageList(String searchWord, Integer pageNo, Integer pageSize);



    IPage<InfoSourceVo> bindInfoSourcePageList(InfoSourceCondition infoSourceCondition, List<String> subjectIdList, Integer pageNo, Integer pageSize);

    /**
     * 信息源下专题绑定的栏目列表(专题绑定定向信息源时使用-研究中心)
     *
     * @param subjectId 专题id
     * @param webSiteNames 信息源名称集合
     * @author lkg
     * @date 2025/2/12
     */
    List<InfoSource> subjectBindSourceColumnList(String subjectId,List<String> webSiteNames);
}
