package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.SysBaseRegion;
import com.zzsn.event.mapper.SysBaseRegionMapper;
import com.zzsn.event.service.ISysBaseRegionService;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.util.tree.TreeUtil;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description: 国内地域表
 * @Author: jeecg-boot
 * @Date:   2022-03-09
 * @Version: V1.0
 */
@Service
public class SysBaseRegionServiceImpl extends ServiceImpl<SysBaseRegionMapper, SysBaseRegion> implements ISysBaseRegionService {


    @Override
    public List<String> belowIdList(String regionId) {
        LambdaQueryWrapper<SysBaseRegion> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.like(SysBaseRegion::getPathIds,regionId);
        List<SysBaseRegion> sysBaseRegions = baseMapper.selectList(queryWrapper);
        List<Node> nodes = new ArrayList<>();
        for (SysBaseRegion sysBaseRegion : sysBaseRegions) {
            Node node = new Node();
            node.setId(sysBaseRegion.getId());
            node.setName(sysBaseRegion.getNameCn());
            node.setPid(sysBaseRegion.getPid());
            nodes.add(node);
        }
        return TreeUtil.belowList(nodes,regionId,true);
    }
}
