package com.zzsn.event.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.entity.SysBaseLabelType;
import com.zzsn.event.vo.LabelTypeVO;

import java.util.List;

/**
 * @Description: 标签类别
 * @Author: jeecg-boot
 * @Date: 2022-05-12
 * @Version: V1.0
 */
public interface SysBaseLabelTypeService extends IService<SysBaseLabelType> {

    String ROOT_ID = "0";

    /**
     * 获取下级所有节点的id集合
     *
     * @param id 标签id
     * @author lkg
     * @date 2024/12/27
     */
    List<String> belowList(String id);

    /**
     * 标签类别树
     *
     * @param labelType 标签类别
     * @author lkg
     * @date 2024/12/27
     */
    List<LabelTypeVO> labelTypeTree(String labelType);
}
