package com.zzsn.event.xxljob.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 定制化信息源管理表
 * @Author: jeecg-boot
 * @Date:   2021-11-10
 * @Version: V1.0
 */
@Data
@TableName("special_info_source")
@ApiModel(value="special_info_source对象", description="定制化信息源管理表")
public class SpecialInfoSource implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
	/**信息源编码*/
    @ApiModelProperty(value = "信息源编码")
    private String infoCode;
	/**爬虫名称*/
    @ApiModelProperty(value = "爬虫名称")
    private String carwlname;
	/**爬取类别*/
    @ApiModelProperty(value = "爬取类别")
    private String type;
	/**关键词*/
    @ApiModelProperty(value = "关键词")
    private String keyWords;
	/**调度周期*/
    @ApiModelProperty(value = "调度周期")
    private String cron;
	/**调度时间间隔*/
    @ApiModelProperty(value = "调度时间间隔")
    private String period;
	/**调度周期说明*/
    @ApiModelProperty(value = "调度周期说明")
    private String remarkCron;
	/**页数*/
    @ApiModelProperty(value = "页数")
    private String pagenum;
	/**信息源状态*/
    @ApiModelProperty(value = "信息源状态")
    private String status;
	/**开始时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value = "开始时间")
    private Date startTime;
	/**结束时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value = "结束时间")
    private Date endTime;
	/**技术说明*/
    @ApiModelProperty(value = "技术说明")
    private String explanation;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private Date updateTime;
	/**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private String sysOrgCode;
}
