package com.zzsn.event.vo;

import lombok.Data;

import java.util.List;

@Data
public class SpecialInformation {
    //的索引名
    private String dbIndex;
    //说明：...Raw 表示原文，即原语言
    //作者
    private String author;
    private String authorRaw;
    //正文
    private String content;
    private String contentRaw;
    //带标签正文
    private String contentWithTag;
    private String contentWithTagRaw;
    //入库时间
    private String createDate;
    //信息id
    private String id;
    //信息来源id(信息源或者关键词)
    private String sid;
    //信息源分类id
    private String infoSourceNatureId;
    //语言
    private String lang;
    private String langRaw;
    //来源（信息来源）
    private String origin;
    private String originRaw;
    //发布时间
    private String publishDate;
    //原始时间（网页上，没有解析之前的时间）
    private String originalTime;
    //发布地址
    private String sourceAddress;
    //摘要
    private String summary;
    private String summaryRaw;
    //关键词
    private String keyWords;
    //标题
    private String title;
    private String titleRaw;
    //采集来源（如通用、定制、微信公众号等）
    private String source;
    //附加字段
    private String type;
    //视频下载链接
    private String downLoadUrl;
    //视频链接（原链接 网页版）
    private String videoUrl;
    //视频链接（原链接 手机版）
    private String videoPhoneUrl;
    //视频时长
    private Long videoTime;
    //视频第一帧图片
    private String videoImg;
    //自定义标签
    private List<String> customLabel;
    private Double score;
    //专题库类型(0: 其它 1：政策；2：领导讲话；3：专家观点；4：企业案例)
    private Integer classificationType;
    //置顶排位(默认为0)
    private Integer topNum;
    //删除标记(1:删除；0:保留)
    private Integer deleteFlag;
    private String subjectId;
    private List<String> subjectIdList;
    //审核操作(0：未审核  1：审核通过  2：审核未通过  3：暂定  默认值为0)
    private Integer checkStatus;
    //阅读数
    private Long readNum = 0L;
    //是否收藏
    private boolean ynCollect = false;
    //重复id
    private String repeatId;
    //（1：主条目  0：非主条目）
    private String flag;
    //关联的主条目id
    private String masterEntryId;
    //原始id(去重服务生成的id,因为一条信息可以属于多个专题，原始id会发生改变，所以存储一个原始id,找寻对应关系)
    private String originalId;
    //快照地址
    private String screenShotImg;
    //资讯更新时间
    private String updateDate;
    //信息类别（1：报刊  2：博客  3：客户端  4：论坛  5：视频  6：外媒  7：网站  8：微博  9：微信  10：新闻  11：政务  12：其它）
    private String infoSourceType;
    //舆情监测：yqjc、舆情预警：yqyj、舆情分析：yqfx、舆情报告：yqbg、竞争情报：jzqb、口碑监测：kbjc
    private String dataType;
    //资讯关联的附件id
    private List<String> attachmentIds;
    //数据入专题库时间
    private String processDate;
    //点赞数字
    private Integer likesNum = 0;
    //法规号
    private String contentNo;
    //用户id
    private String userId;
    //封面附件id
    private String coverEnclosureId;
    //封面图url地址
    private String coverImgUrl;
    //发布状态 checkStatus=1时生效(0/null：待发布  1：已发布  2：已下架  默认值为null)
    private Integer publishStatus;
    //关联附件id
    private List<String> enclosureIds;
    private String imgDisposeStatus;
    /**公开方式 0会员 1公开*/
    private Integer publishMethod=0;
    /**栏目id*/
    private List<String> columnIds;

    /**抖音微博作品点赞数*/
    private Integer likeNum;
    /**抖音微博贴吧作品评论数*/
    private Integer commentNum;
    /**抖音收藏数*/
    private Integer collectNum;
    /**抖音微博 分享数*/
    private Integer shareNum;
    /**作品、帖子唯一标识*/
    private String articleId;
    /**作品、帖子唯一标识*/
    private String index;

    /**信息源类别id*/
    private String infoSourceTypeId;

    /**资讯是否包含图片，1：资讯包含图片    0：资讯不包含图片*/
    private String isIncludeImg;
    //关键词
    private List<String> keyWordsList;

}
