package com.zzsn.event.util;

import org.springframework.util.StringUtils;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {

    public static boolean convertBoolean(String s, boolean b) {
        if (s == null) {
            return b;
        }
        if (s.equals("0")) {
            return false;
        }
        if (s.equals("1")) {
            return true;
        }
        return b;
    }

    public static String convertBooleanToString(boolean b) {
        String s = b ? "1" : "0";
        return s;
    }

    public static String trimWhiteSpace(String str) {
        String s = replaceBlank(str);
        String ret = s.trim();
        return ret;
    }

    public static String replaceBlank(String str) {
		/*       String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");su
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }*/
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < str.length(); i++) {
            char c = str.charAt(i);
            boolean bspace = Character.isWhitespace(c);
            if (bspace) {
                c = ' ';
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    //获取分隔符[和]之间的子串，如aa[abc]bbb->abc
    public static List<String> getSubStrs(String str, String start, String end) {
        List<String> resultStrs = new ArrayList<String>();
        if (str == null || str.trim().length() == 0) {
            return resultStrs;
        }
        String ptnstr = String.format("%s([^%s%s]+)%s", start, start, end, end);
        //	String ptnstr1 = "\\[([^\\[\\]]+)\\]";
        Pattern pattern = Pattern.compile(ptnstr);
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            String substr = matcher.group(1);
            resultStrs.add(substr);
        }
        return resultStrs;
    }

    //fromStr:aaa123bb, origStr:aaa[xxx]bb, replaceStr:[xxx]. return:123
    public static String getHomologousWord(String replaceStr,
                                           String origStr, String fromStr) {
        String retStr = null;
        int pos = origStr.indexOf(replaceStr);
        if (pos == -1) {
            return retStr;
        }
        String start = origStr.substring(0, pos);
        String end = origStr.substring(pos + replaceStr.length());
        if (start.length() > 0 && !fromStr.startsWith(start)) {
            return retStr;
        }
        if (end.length() > 0 && !fromStr.endsWith(end)) {
            return retStr;
        }
        retStr = fromStr.substring(start.length(),
                fromStr.length() - end.length());
        return retStr;
    }

    public static String trimBeginningBracket(String s) {
        String ret = s;
        if (s.length() == 0) {
            return s;
        }
        Map<Character, Character> braketPeers
                = new HashMap<Character, Character>();
        braketPeers.put('【', '】');
        braketPeers.put('[', ']');
        braketPeers.put('［', '］');
        braketPeers.put('(', ')');
        braketPeers.put('（', '）');
        braketPeers.put('〔', '〕');
        String searchStr = s;
        while (searchStr.length() > 0) {
            char beginc = searchStr.charAt(0);
            Character value = braketPeers.get(beginc);
            if (value == null) {
                break;
            }
            int endPos = -1;
            for (int i = 1; i < searchStr.length(); i++) {
                if (searchStr.charAt(i) == value) {
                    endPos = i;
                    break;
                }
            }
            if (endPos >= 0) {
                ret = searchStr.substring(endPos + 1);
                searchStr = ret;
            } else {
                break;
            }
        }
        return ret;
    }

    public static String trimMiddleBracket(String s) {
        String ret = s;
        if (s.length() == 0) {
            return s;
        }
        Map<Character, Character> braketPeers = new HashMap<Character, Character>();
        String[] brakets = {"】", "]", "］", ")", "）", "〕"};
        braketPeers.put('【', '】');
        braketPeers.put('[', ']');
        braketPeers.put('［', '］');
        braketPeers.put('(', ')');
        braketPeers.put('（', '）');
        braketPeers.put('〔', '〕');
        String searchStr = s;
        int index = 0;
        while (searchStr.length() > 0) {

            int startPos = -1;
            Character value = null;
            for (int i = index; i < searchStr.length(); i++) {
                boolean findLeftBraket = false;
                value = searchStr.charAt(i);
                for (Character key : braketPeers.keySet()) {
                    if (value.equals(key)) {
                        startPos = i;
                        findLeftBraket = true;
                        break;
                    }
                }
                if (findLeftBraket) {
                    break;
                }
            }
            int endPos = -1;
            for (int i = startPos + 1; i < searchStr.length(); i++) {
                if (null != braketPeers.get(value) && searchStr.charAt(i) == braketPeers.get(value)) {
                    endPos = i;
                    break;
                }
            }
            if (endPos >= startPos) {
                if (startPos >= 0) {
                    searchStr = searchStr.substring(0, startPos) + searchStr.substring(endPos + 1, searchStr.length());
                }
            } else {
                searchStr = searchStr.replace(value.toString(), "");
                index = startPos;
            }
            if (startPos < 0) {
                ret = searchStr;
                break;
            }
        }
        for (String bs : brakets) {
            ret = ret.replace(bs.toString(), "");
        }
        return ret;
    }

    public static String trimEnddingBracket(String s) {
        String ret = s;
        if (s.length() == 0) {
            return s;
        }
        Map<Character, Character> braketPeers
                = new HashMap<Character, Character>();
        braketPeers.put('】', '【');
        braketPeers.put(']', '[');
        braketPeers.put(')', '(');
        braketPeers.put('）', '（');
        braketPeers.put('〕', '〔');
        int endPos = s.length() - 1;
        String searchStr = s;
        while (endPos >= 0) {
            char endc = searchStr.charAt(endPos);
            Character value = braketPeers.get(endc);
            if (value == null) {
                break;
            }
            int startPos = -1;
            for (int i = searchStr.length() - 2; i >= 0; i--) {
                if (searchStr.charAt(i) == value) {
                    startPos = i;
                    break;
                }
            }
            if (startPos >= 0) {
                ret = searchStr.substring(0, startPos);
                searchStr = ret;
            }
            endPos = startPos - 1;
        }
        return ret;
    }


    public static String delCharNotChinese(String s) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < s.length(); i++) {
            char c = s.charAt(i);
            if (isChinese(c)) {
                buffer.append(c);
            }
        }
        return buffer.toString();
    }

    public static boolean isChinese(char c) {
        if (c >= 0x4e00 && c <= 0x9fa5) {
            return true;
        }
        return false;
    }

    public static String toBanjiao(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < s.length(); i++) {
            char c = s.charAt(i);
            if (c >= 65281 && c <= 65374) {
                c = (char) (c - 65248);
            } else if (c == 12288) { // 空格
                c = (char) 32;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String listToString(List<String> arr) {
        StringBuffer buffer = new StringBuffer();
        if (arr == null) {
            return buffer.toString();
        }
        for (int i = 0; i < arr.size(); i++) {
            buffer.append(arr.get(i));
            if (i != arr.size() - 1) {
                buffer.append(";");
            }
        }
        return buffer.toString();
    }

    public static List<String> stringToList(String str) {
        List<String> strs = new ArrayList<String>();
        if (str == null) {
            return strs;
        }
        String[] ss = str.split(";");
        for (String s : ss) {
            if (s.trim().length() == 0) {
                continue;
            }
            strs.add(s);
        }
        return strs;
    }

    public static String normalizeHtmlTransf(String s) {
        String ret = s.replaceAll("&bull;", "·");
        ret = ret.replaceAll("&middot;", "·");
        ret = ret.replaceAll("&nbsp;", " ");
        ret = ret.replaceAll("&quot;", "\"");
        ret = ret.replaceAll("&amp;", "&");
        ret = ret.replace('・', '·');
        ret = ret.replace("&ldquo;", "\"");
        ret = ret.replace("&rdquo;", "\"");
        ret = ret.replace("&hellip;", "...");
        ret = ret.replace("&lt;", "<");
        ret = ret.replace("&gt;", ">");
        ret = ret.replace("&mdash;", "—");
        ret = ret.replace("&ndash;", "–");
        ret = ret.replace("&tilde;", "~");
        ret = ret.replace("&lsquo;", "'");
        ret = ret.replace("&rsquo;", "'");
        ret = ret.replace("&sbquo;", ",");
        ret = ret.replace("&lsaquo;", "‹");
        ret = ret.replace("&rsaquo;", "›");
        ret = ret.replace("&hellip;", "…");
//        ret = ret.replace("|", " ");
        return ret;
    }

    public static String normalizeSegTransf(String s) {
        String ret = s.replaceAll("\r\n;", " ");
        ret = ret.replace("\n", "");
        ret = ret.replace("|", " ");
        return ret;
    }

    /**
     * @Description 获取srcList中在text存在的集合(包含频次)
     * @author kongliufeng
     * @创建时间 2020/9/3 18:41
     * @Version 1.0
     */
    public static Map<String, Integer> getHitWordsAndTimes(Collection<String> srcList, String text){
        Map<String, Integer> map = new HashMap<>();
        if(srcList==null || StringUtils.isEmpty(text)){
            return  map;
        }
        for (String s : srcList) {
            int i = countKeyWordInContent(s, text);
            if(i>0){
                map.put(s,i);
            }
        }
        return map;
    }

    /**
     * @Description 判断一个词是否在文本中
     * @author kongliufeng
     * @创建时间 2020/9/3 18:26
     * @Version 1.0
     */
    public static Boolean isKeyWordInText(String keyWord, String text){
        if(keyWord==null || text==null)
            return false;
        int leng = text.length();
        int j = 0;
        for (int i = 0; i < leng; i++){
            if (text.charAt(i) == keyWord.charAt(j)){
                j++;
                if (j == keyWord.length()){
                    return true;
                }
            }
            else{
                i = i - j;
                j = 0;
            }
        }
        return false;
    }

    /**
     * @Description 计算一个词在一个文本中的次数
     * @author kongliufeng
     * @创建时间 2020/8/27 19:56
     * @Version 1.0
     */
    public static int countKeyWordInContent(String keyword, String srcContent){
        if(keyword==null ||keyword.trim().equals("")){
            return 0;
        }
        int count = 0;
        int leng = srcContent.length();
        int j = 0;
        for (int i = 0; i < leng; i++){
            if (srcContent.charAt(i) == keyword.charAt(j)){
                j++;
                if (j == keyword.length()){
                    count++;
                    j = 0;
                }
            }
            else{
                i = i - j;
                j = 0;
            }
        }
        return count;
    }

    /**
     * @Description 在文本中根据自定义组合词匹配,返回匹配中的词
     *  例如：组合词如：(产业链|供应链)+主席 == 主席+供应链;产业链+主席
     *
     *                  括号里面是或
     * @author kongliufeng
     * @创建时间 2020/9/9 10:05
     * @Version 1.0
     */
    public static String matchComposeWords(String content , String composeWords){
        if(content==null || composeWords == null)
            return null;
        String[] matchGroups = composeWords.split(";");
        StringBuilder sb = new StringBuilder();
        Boolean isMatch = false;
        for(String group :matchGroups){//分组,匹配其中之一即可
            String[] allContent = group.split("\\+");
            Boolean allContentHit = true;
            StringBuilder groupMatch = new StringBuilder();
            for(String ss :allContent){//全部需要匹配
                Boolean orContentHit = false;
                String[] orContent  = ss.replaceAll("[()]", "").split("\\|");
                for(String sss:orContent){//匹配其一即可跳出
                    //isKeyWordInText(sss,content)
                    if(content.contains(sss)){
                        //sb.append(sss).append(",");
                        groupMatch.append(sss).append(",");
                        orContentHit=true;
                        break;
                    }
                }
                if(orContentHit){
                    continue;
                }else{
                    allContentHit = false;
                    break;
                }
            }
            if(allContentHit){
                sb.append(groupMatch);
                isMatch = true;
                break;
            }
        }
        if(isMatch){
            return sb.toString();
        }else{
            return null;
        }
    }
}
