package com.zzsn.event.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;

/**
 * @Description: 事件
 * @Author: jeecg-boot
 * @Date:   2024-03-14
 * @Version: V1.0
 */
@Data
@TableName("event")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="event对象", description="事件")
public class Event {
    
	/**ID*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "ID")
	private String id;
	/**名称*/
	@Excel(name = "名称", width = 15)
    @ApiModelProperty(value = "名称")
	private String eventName;
	/**图标*/
	@Excel(name = "图标", width = 15)
    @ApiModelProperty(value = "图标")
	private String eventIcon;
	/**事件类型*/
	@Excel(name = "事件类型", width = 15)
    @ApiModelProperty(value = "事件类型")
	private String eventType;
	/**开始时间*/
	@Excel(name = "开始时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "开始时间")
	private Date startTime;
	/**结束时间*/
	@Excel(name = "结束时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "结束时间")
	private Date endTime;
	/**事件地域*/
	@Excel(name = "事件地域", width = 15)
    @ApiModelProperty(value = "事件地域")
	private String eventArea;
	private String eventAreaId;
	/**标签*/
	@Excel(name = "标签", width = 15)
    @ApiModelProperty(value = "标签")
	private String eventLabel;
	private String eventLabelIds;
	/**关键词*/
	@Excel(name = "关键词", width = 15)
    @ApiModelProperty(value = "关键词")
	private String eventKeywords;
	/**是否公开*/
	@Excel(name = "是否公开", width = 15)
    @ApiModelProperty(value = "是否公开")
	private Integer facePublic;
	/**事件描述*/
	@Excel(name = "事件描述", width = 15)
    @ApiModelProperty(value = "事件描述")
	private String eventDescribe;
	/**创建人id*/
	@Excel(name = "创建人id", width = 15)
    @ApiModelProperty(value = "创建人id")
	private String createBy;
	/**创建时间*/
	@Excel(name = "创建时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
	private Date createTime;
	/**修改时间*/
	@Excel(name = "修改时间", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "修改时间")
	private Date updateTime;
	/**修改人id*/
	@Excel(name = "修改人id", width = 15)
    @ApiModelProperty(value = "修改人id")
	private String updateBy;
	private Integer status=1;
	/**
	 * 分析事件脉络-最新资讯的时间
	 */
	@DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	private Date analysisTime;
	@DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
	private Date eventTime;
	@TableField(exist = false)
	private String typeName;
	private String eventCode;
	private String cron;
	/**事件专题增量分析规则*/
	@ApiModelProperty(value = "事件专题增量分析规则")
	private Integer increAnaRule;
	/**事件专题总量分析规则*/
	@ApiModelProperty(value = "事件专题总量分析规则")
	private Integer totalAnaRule;
	/**事件专题时间间隔分析规则(天)*/
	@ApiModelProperty(value = "事件专题时间间隔分析规则(天)")
	private Integer timeAnaRule;
	private Integer totalHot;
	private Integer mediaHot;
	private Integer wechatHot;
	private Integer otherHot;
	private Integer publishStatus;
	private String relationEvents;
	private  String publishDate;


	@TableField(exist = false)
	private String startDate;
	@TableField(exist = false)
	private String endDate;
	@TableField(exist = false)
	private List<Event>  relatedEventList;
	@TableField(exist = false)
	private EventTag eventTag;
	@TableField(exist = false)
	private String extractIndustryTag;
	@TableField(exist = false)
	private String extractCompanyTag;
	@TableField(exist = false)
	private String extractPersonTag;
	@TableField(exist = false)
	private String extractSentimentTag;
	@TableField(exist = false)
	private String extractKeywordsTag;
	@TableField(exist = false)
	private String extractLocationTag;
	@TableField(exist = false)
	private String extractTimeTag;
}
