package com.zzsn.event.util;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;

/**
 * @author kongliufeng
 * @Description TODO: 自定义排序
 * @create 2020-09-03 19:11
 * @Version 1.0
 */
public class SortUtil {
    public static final DateTimeFormatter dtf2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static List<Map.Entry<String, Integer>> sortMap(Map<String,Integer> map){
        if(map!=null){
            List<Map.Entry<String, Integer>> list = new ArrayList<>(map.entrySet());
            Collections.sort(list,new Comparator<Map.Entry<String, Integer>>() {
                @Override
                public int compare(Map.Entry<String, Integer> o1,
                                   Map.Entry<String, Integer> o2) {
                    return o2.getValue() - o1.getValue();
                }
            });
            return  list;
        }
        return  new ArrayList<Map.Entry<String, Integer>>();
    }

    public static int dateLg(String s1,String s2){
        if(s1.equals(s2)){
            return 0;
        }
        int temp = 0;
        if(s1.length()==10){
            s1 = s1 +" 00:00:00";

        }
        if(s2.length()==10){
            s2 = s2 +" 00:00:00";
        }
        try {
            LocalDateTime localDateTime1 = LocalDateTime.parse(s1, dtf2);
            LocalDateTime localDateTime2 = LocalDateTime.parse(s2, dtf2);
            if(localDateTime1.isEqual(localDateTime2)){
                temp = 0;
            }
            temp = localDateTime1.isBefore(localDateTime2)==true? 1:-1;
            StringBuilder sb = new StringBuilder();
            sb.append("s1对比s2").append(s1).append(":").append(s2).append("返回结果").append(temp);
            return temp;
        }catch (Exception e){
            e.printStackTrace();
            return -1;
        }
    }

    public static void main(String[] args) {
        String s1= "2020-10-22" ;
        String s2= "2020-10-23";
        System.out.println(s1.length());
        System.out.println(dateLg(s1, s2));
    }
}
