package com.zzsn.event.util;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

/**
 * @author 闫鑫
 * @date 2022/6/21 12:01
 */
@Slf4j
public class FileUtil {
    /**
     * @Description: 读取resources 目录下的文件
     * @param filePath 相对路径
     * @Return: 文件实际地址
     **/
    public static String getFilePath(String filePath){
        return Thread.currentThread().getContextClassLoader().getResource(filePath).getPath();
    }

    /**
     * 读取classpath路径下的文本文件，返回list
     * @param filePath
     * @return
     * @throws IOException
     */
    public static List<String> readFileList(String filePath){
        List<String> list = new ArrayList<>();
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            // ClassPathResource类的构造方法接收路径名称，自动去classpath路径下找文件
            ClassPathResource classPathResource = new ClassPathResource(filePath);
            // 打成jar包后，只能获取输入流对象
            inputStream = classPathResource.getInputStream();
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            bufferedReader = new BufferedReader(inputStreamReader);
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if(oConvertUtils.isNotEmpty(line)){
                    list.add(line);
                }
            }
        }catch (IOException e){
            log.error("读取文件失败,filePath：{}，e：{}",filePath,e);
        }finally {
            // 统一在finally中关闭流，防止发生异常的情况下，文件流未能正常关闭
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static InputStream  DownloadFileFormServer(String strUrl) {
		InputStream inputStream = null;
		HttpURLConnection conn = null;
		try {
			URL url = new URL(strUrl);
			conn = (HttpURLConnection) url.openConnection();
			conn.setRequestMethod("GET");
			conn.setConnectTimeout(20 * 1000);
			// 模板文件名
			// 模板文件路径
			inputStream = conn.getInputStream();
		} catch (Exception e) {
		} finally {
		}
		return inputStream;
	}
    
    
    /**
     * 获取resource下的文件内容
     *
     * @param path
     * @return
     */
    public static String getResource(String path) throws IOException {
        if (StringUtils.isBlank(path)) {
            return null;
        }
        ClassPathResource classPathResource = new ClassPathResource(path);
        StringBuilder stringBuilder = new StringBuilder();
        InputStream inputStream =null;
        try {
            inputStream = classPathResource.getInputStream();
            byte[] bytes = new byte[1024];
            int lenth;
            while ((lenth = inputStream.read(bytes)) != -1) {
                stringBuilder.append(new String(bytes, 0, lenth));
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("读取文件错误");
        }finally {
            inputStream.close();
        }
        return stringBuilder.toString();
    }
    
    public static String getFileNameFormPath(String fileName){
    	if(fileName == null || StringUtils.isEmpty(fileName)){
    		return null;
    	}
    	fileName = fileName.trim();
    	fileName = fileName.replace("\\", "/");
    	while(fileName.endsWith("/")){
    		fileName = fileName.substring(0, fileName.length() -1);
    	}
    	if(fileName.contains("/")){
    		fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
    	}
    	return fileName; 
    }

    /**
     * 根据文件的字节大小计算显示大小
     *
     * @param size
     * @return
     */
    public static String readableFileSize(long size) {
        if (size <= 0) return "0";
        final String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int) (Math.log10(size) / Math.log10(1024));
        return new DecimalFormat("#,##0.#").format(size / Math.pow(1024, digitGroups)) + units[digitGroups];
    }
}
