package com.zzsn.event.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.zzsn.event.entity.Event;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.entity.LabelEntity;
import com.zzsn.event.vo.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Description: 事件
 * @Author: jeecg-boot
 * @Date:   2024-03-14
 * @Version: V1.0
 */
public interface IEventService extends IService<Event> {
    /**
     * 计算热度
     */
    void compute();

    List<SubjectKafkaVo> progressList(Date disableDate);

    List<SubjectKafkaVo> eventSubjectList();

    IPage<Event> pageList(Event event, Integer pageNo, Integer pageSize,String order,String orderType);

    void extractHotWords(AddEventParam event);

    Event saveMain(AddEventParam addEventParam);

    void updateMain(AddEventParam addEventParam);
    /**
     * 获取专题绑定的关键词组列表
     */
    List<KeyWordsPage> bindKeyWordsList(String id);

    void deleteMain(String id);

    String upload(MultipartFile file);

    List<LabelEntity> listByType(String labelTypeId);

    DisplayInfo articleDetail(String articleId);

    Result<?> hotWords(String id, Integer number);
}
