package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.entity.SubjectSearchEnginesMap;
import com.zzsn.event.vo.SearchEnginesVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description: 专题与搜索引擎关联表
 * @Author: jeecg-boot
 * @Date:   2022-06-21
 * @Version: V1.0
 */
@Mapper
public interface SubjectSearchEnginesMapMapper extends BaseMapper<SubjectSearchEnginesMap> {

    void deleteBySubjectId(@Param("subjectId") String subjectId);

    List<SearchEnginesVo>  bindSearchEngineList(@Param("searchEnginesVo") SearchEnginesVo searchEnginesVo);

    List<String> querySearchList(@Param("subjectId") String subjectId);
}
