package com.zzsn.event.enums;

/**
 * Description:
 *
 * @author: EDY
 * @since: 2024/1/9
 */

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Description:
 * Author: EDY
 * Date: 2023/10/9
 */
public enum KnowTypeEnum {
    Notice("公告","1"),
    LeadershipSpeech("领导讲话","2"),

    YearReport("年报","3"),

    JournalArticle("期刊论文","3"),
    Book("图书","4"),
    ResearchReport("研报","5"),
    Policies("政策法规","6"),
    Message("资讯","7"),
    ;


    public static List<KnowTypeEnum> getAll(){
        KnowTypeEnum[] values = KnowTypeEnum.values();
        return Arrays.asList(values);
    }
    public static Map<String,String> getAllAsMap(){
        Map<String , String> res = new HashMap<>();
        KnowTypeEnum[] values = KnowTypeEnum.values();
        for (KnowTypeEnum value : values) {
            res.put(value.des,value.type);
        }
        return res;
    }

    public static KnowTypeEnum getByDes(String des) {
        for (KnowTypeEnum enumValue : KnowTypeEnum.values()) {
            if (enumValue.getDes().equals(des)) {
                return enumValue;
            }
        }
        throw new IllegalArgumentException("No enum constant with value: " + des);
    }

    public static KnowTypeEnum getByType(String type) {
        for (KnowTypeEnum enumValue : KnowTypeEnum.values()) {
            if (enumValue.getType().equals(type)) {
                return enumValue;
            }
        }
        throw new IllegalArgumentException("No enum constant with value: " + type);
    }



    /**路径描述*/
    private final String des;
    /**路径描述*/
    private final String type;

    public String getType() {
        return type;
    }



    public String getDes() {
        return des;
    }

    KnowTypeEnum( String des ,String type) {
        this.des = des;
        this.type = type;

    }
}
